<?php /* Code:250519 Version: V 0.1 Date: 2025-05-20 */ ?>
<?php
class DB_Connection{
  public $conn      = false;
  private $host     = 'localhost'; //hostname;
  private $user     = 'sutracomputers_manager'; //username;
  private $password = 'Tn[}-l9eVX]l'; //password ; 
  private $dbname   = 'sutracomputers_projects'; //name of your database;
  private $port     = '';
  private $debug    = true;


function __destruct() {
    $this->close();
}


  /*
    @author     : jaiprakash chauhan
    @param      : $query, $conn
    @return     : 
    @Description  : This is a connection function will will connect interface with the database.
    @created Date : 05-Nov-2019
    Example : 
          $User = $bdd->getOne('SELECT id, firstname, lastname FROM users WHERE lastname = "Smith"'); // 1 line selection, return 1 line
          echo $User['id'].'<br>'; // display the id
          echo $User['firstname'].'<br>'; // display the first name
          echo $User['lastname']; // display the last name

  */
  function connect() {
    if (!$this->conn) {
      try {
        $this->conn = new PDO('mysql:host='.$this->host.';dbname='.$this->dbname.'', $this->user, $this->password, array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8'));
      }

      catch (Exception $e) {
        die('error msg : ' . $e->getMessage());
      }

 

      if (!$this->conn) {
        $this->status_fatal = true;
        echo 'Connection failed';
        die();
      } 
      else {
        // echo 'Connection success';
        $this->status_fatal = false;
      }
    }
    return $this->conn;
  }
  
  function close() {
    if ($this->conn) {
      $this->conn = null;
    }
  }

  

  

  /*
    @author     : jaiprakash chauhan
    @param      : $query, $conn
    @return     : 
    @Description  : This function will return a single record from the table based on the query, The data will be in associated array as fetch assoc does.
              Here you can call any log which will impact intire system when thease functionality will call.
    @created Date : 05-Nov-2019
    Example : 
          $User = $bdd->getOne('SELECT id, firstname, lastname FROM users WHERE lastname = "Smith"'); // 1 line selection, return 1 line
          echo $User['id'].'<br>'; // display the id
          echo $User['firstname'].'<br>'; // display the first name
          echo $User['lastname']; // display the last name
  */
  function getOne($query, $conn){
    $result     = $conn->prepare($query);
    $ret        = $result->execute();
    if (!$ret) {
         echo 'PDO::errorInfo():';
         echo 'error SQL: '.$query;
         die();
    }
    $result->setFetchMode(PDO::FETCH_ASSOC);
    $reponse    = $result->fetch();
    return $reponse;
  }





public function Num_Rows_Function($query,$conn)
{
    // Assuming you have a valid database connection in $newConn
    $result = $conn->query($query);
    if (!$result) {
        die("Query execution failed: " . $conn->error);
    }
    $num_rows = mysqli_num_rows($result);
    $result->close();
    return $num_rows;
}


  

  /*
    @author     : jaiprakash chauhan
    @param      : $query, $conn
    @return     : 
    @Description  : This function will return a all the record from the table based on the query, The data will be in associated array as fetch assoc does.
              Here you can call any log which will impact intire system when thease functionality will call.
    @created Date : 05-Nov-2019
    Example : 
          $Users = $bdd->getAll('SELECT id, firstname, lastname FROM users'); // select ALL from users    
          $nbrUsers = count($Users); // return the number of lines           
          echo $nbrUsers.' users in the database<br />';            
          foreach($Users as $user) { // display the list
          echo $user['id'].' - '.$user['firstname'].' - '.$user['lastname'];  
  */
  function getAll($query, $conn) {
    $result     = $conn->prepare($query);
    $ret        = $result->execute();
    if (!$ret) {
         echo 'PDO::errorInfo():';
         echo 'error SQL: '.$query;
         die();
    }
    $result->setFetchMode(PDO::FETCH_ASSOC);
     $reponse   = $result->fetchAll();
    return $reponse;
  }

  

  




  /*
    @author     : jaiprakash chauhan
    @param      : $query, $conn
    @return     : 
    @Description  : This function will return refrence key of the query execution, here this function will just execute the query and return 
              an success or fail msg.
              Here you can only call insert (single / multi), update, delete, drop, truncate, create etc.
              Here you can call any log which will impact intire system when thease functionality will call.
    @created Date : 05-Nov-2019
    Example : 
          $query = $bdd->execute('INSERT INTO users (firstname, lastname) VALUES ("firstname1", "lastname1")');
          $query = $bdd->execute('UPDATE users SET firstname="firstname2", lastname="lastname2" WHERE id=20');
  */
  function execute($query,$conn) {
    $response = $conn->exec($query);
    // echo $response;
    if (!$response && $response!=0) {
        echo 'PDO::errorInfo():';
         //echo '<br />';
         echo 'error SQL: '.$query;
         die($this->QueryDie($query, __LINE__, $PROGRAMNAME, $FILENAME, $LID, '',''));
         $response = 'error'; 
    }
    // echo $reponse;
    return $response;
  }



  //added 17-08-2021 for escaping characters.
  function mysql_escape_mimic($inp) {
    if(is_array($inp))
        return array_map(__METHOD__, $inp);
    if(!empty($inp) && is_string($inp)) {
        return str_replace(array('\\', "\0", "\n", "\r", "'", '"', "\x1a"), array('\\\\', '\\0', '\\n', '\\r', "\\'", '\\"', '\\Z'), $inp);
    }
    return $inp;
  }


  //function for applying escape string 
	function Escape_String_Function($data)
	{
		if($data)
		{	
			$result =  mysqli_escape_string($conn,$data);
			return $result;
		}
	}
}
?>




